<aside id="sidebar"
    class="w-64 bg-white border-r border-gray-200 fixed md:static inset-y-0 left-0 z-40 overflow-y-auto">
    <!-- Logo -->
    <div class="gradient-gray p-6 text-white">
        <div class="flex items-center justify-between">
            <div>
                <div class="space-y-5">
                    <div class="logo-container flex justify-center">
                        <img src="<?php echo e(asset('img/Logo.png')); ?>" alt="HARRIS Hotel Logo" class="h-20 object-contain">
                    </div>
                </div>
            </div>
            <button onclick="toggleSidebar()" class="md:hidden text-white">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
    </div>

    <!-- Navigation Menu -->
    <nav class="p-4 space-y-2">
        <!-- Dashboard -->
        <a href="<?php echo e(route('admin.dashboard')); ?>"
            class="sidebar-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
            <i class="fas fa-home w-5"></i>
            <span>Dashboard</span>
        </a>

        <a href="<?php echo e(route('admin.user.index')); ?>"
            class="sidebar-link <?php echo e(request()->routeIs('admin.user.index') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
            <i class="fas fa-user w-5"></i>
            <span>User</span>
        </a>

        <a href="<?php echo e(route('admin.departemen.index')); ?>"
            class="sidebar-link <?php echo e(request()->routeIs('admin.departemen.index') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
            <i class="fas fa-user w-5"></i>
            <span>Departemen</span>
        </a>
        

        <!-- Manajemen Karyawan -->
        <div class="space-y-1">
            <p class="px-4 text-xs font-semibold text-gray-400 uppercase tracking-wider mt-4 mb-2">Manajemen</p>

            <a href="<?php echo e(route('admin.karyawan.index')); ?>"
                class="sidebar-link <?php echo e(request()->routeIs('admin.karyawan.*') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-users w-5"></i>
                <span>Karyawan</span>
            </a>

            <a href="<?php echo e(route('admin.jabatan.index')); ?>"
                class="sidebar-link <?php echo e(request()->routeIs('admin.jabatan.*') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-briefcase w-5"></i>
                <span>Jabatan</span>
            </a>
        </div>

        <!-- Absensi & Gaji -->
        <div class="space-y-1">
            <p class="px-4 text-xs font-semibold text-gray-400 uppercase tracking-wider mt-4 mb-2">Data</p>

            <a href="<?php echo e(route('admin.absensi.index')); ?>"
                class="sidebar-link <?php echo e(request()->routeIs('admin.absensi.*') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-clock w-5"></i>
                <span>Absensi</span>
            </a>
            <a href="<?php echo e(route('admin.cuti')); ?>"
                class="sidebar-link <?php echo e(request()->routeIs('admin.cuti.*') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-clock w-5"></i>
                <span>Cuti</span>
            </a>

            <a href="<?php echo e(route('admin.gaji.index')); ?>"
                class="sidebar-link <?php echo e(request()->routeIs('admin.gaji.*') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Penggajian</span>
            </a>

            <a href="<?php echo e(route('admin.wajah.index')); ?>"
                class="sidebar-link <?php echo e(request()->routeIs('admin.wajah.*') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Wajah</span>
            </a>

            <a href="<?php echo e(route('admin.shift.index')); ?>"
                class="sidebar-link <?php echo e(request()->routeIs('admin.shift.*') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Shift</span>
            </a>

            <a href="<?php echo e(route('admin.jadwal-shift.index')); ?>"
                class="sidebar-link <?php echo e(request()->routeIs('admin.jadwal-shift.*') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Jadwal Shift</span>
            </a>

            <a href="<?php echo e(route('admin.jatah-cuti.index')); ?>"
                class="sidebar-link <?php echo e(request()->routeIs('admin.jatah-cuti.*') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Jatah Cuti</span>
            </a>

            <a href="<?php echo e(route('admin.activity-log.index')); ?>"
                class="sidebar-link <?php echo e(request()->routeIs('admin.activity-log.*') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Log</span>
            </a>

            <!-- Approval (hanya super admin) -->
            <?php if(auth()->user()->role === 'super_admin'): ?>
                <a href="<?php echo e(route('admin.approval')); ?>"
                    class="sidebar-link <?php echo e(request()->routeIs('admin.approval') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                    <i class="fas fa-check-double w-5"></i>
                    <span>Approval Pengajuan</span>
                </a>
            <?php endif; ?>

            <!-- Ajukan Shift (untuk admin departemen) -->
            <?php if(auth()->user()->role === 'admin'): ?>
                <a href="<?php echo e(route('admin-dept.ajukan-shift.index')); ?>"
                    class="sidebar-link <?php echo e(request()->routeIs('admin-dept.ajukan-shift.*') ? 'active' : ''); ?> flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                    <i class="fas fa-exchange-alt w-5"></i>
                    <span>Ajukan Shift</span>
                </a>
            <?php endif; ?>
        </div>

        <!-- Laporan -->
        

        <!-- Settings -->
        
    </nav>

    <!-- Footer Info -->
    
</aside>
<?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/admin/components/sidebar.blade.php ENDPATH**/ ?>